<?php
/*
=== Load parent Styles ===
*/
function dc_enqueue_styles() {
	wp_enqueue_style( 'divi-parent', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'divi-parent' ) );
}
add_action( 'wp_enqueue_scripts', 'dc_enqueue_styles' );

global $post_id;

//echo $post_id;

add_theme_support('post-thumbnails');
add_image_size('featured_preview', 55, 55, true);

function ST4_get_featured_image($post_ID) {
    $post_thumbnail_id = get_post_thumbnail_id($post_ID);
    if ($post_thumbnail_id) {
        $post_thumbnail_img = wp_get_attachment_image_src($post_thumbnail_id, 'featured_preview');
        return $post_thumbnail_img[0];
    }
}

function ST4_columns_head($columns) {
	
	  $new = array();
	  foreach($columns as $key => $title) {
		if ($key=='date') // Put the Thumbnail column before the Author column
		  $new['featured_image'] = 'Featured Image';
		$new[$key] = $title;
	  }
	  return $new;
	
}
 
// SHOW THE FEATURED IMAGE
function ST4_columns_content($column_name, $post_ID) {
    if ($column_name == 'featured_image') {
        $post_featured_image = ST4_get_featured_image($post_ID);
        if ($post_featured_image) {
            echo '<img src="' . $post_featured_image . '" width="75" height="75" />';
        }
    }
}

add_filter('manage_posts_columns', 'ST4_columns_head');
add_action('manage_posts_custom_column', 'ST4_columns_content', 10, 2);


add_theme_support( 'custom-logo' );

add_image_size( 'right-section', 323, 457, true ); // width, height, crop
add_image_size( 'left-section', 338, 229, true );

add_action( 'after_setup_theme', 'wpdocs_theme_setup' );
function wpdocs_theme_setup() {
    add_image_size( 'grid-posts-custom-size', 123, 67, true ); // (cropped)
}

function post_type_select_services() {
	$labels = array(
    	'name' => _x('New Dental Services', 'post type general name', 'photography-custom-post'),
    	'singular_name' => _x('Dental Service', 'post type singular name', 'photography-custom-post'),
    	'add_new' => _x('Add New Dental Service', 'book', 'photography-custom-post'),
    	'add_new_item' => esc_html__('Add Dental New Service', 'photography-custom-post'),
    	'edit_item' => esc_html__('Edit Dental Service', 'photography-custom-post'),
    	'new_item' => esc_html__('New Dental Service', 'photography-custom-post'),
    	'view_item' => esc_html__('View Dental Service', 'photography-custom-post'),
    	'search_items' => esc_html__('Search Dental Service', 'photography-custom-post'),
    	'not_found' =>  esc_html__('No Dental Service found', 'photography-custom-post'),
    	'not_found_in_trash' => esc_html__('No Dental Service found in Trash', 'photography-custom-post'), 
    	'parent_item_colon' => ''
	);		
	$args = array(
    	'labels' => $labels,
    	'public' => true,
    	'publicly_queryable' => true,
    	'show_ui' => true, 
    	'query_var' => true,
    	'rewrite'   => array( 'slug' => 'dental-services' ),
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'menu_position' => null,
    	'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'comments', 'custom-fields' ),
    	'menu_icon' => get_stylesheet_directory_uri().'/icons/icon.png'
	); 		

	register_post_type( 'select-Services', $args );
	
  	$labels = array(			  
  	  'name' => _x( 'Dental Service Categories', 'taxonomy general name', 'photography-custom-post' ),
  	  'singular_name' => _x( 'Select Dental Category', 'taxonomy singular name', 'photography-custom-post' ),
  	  'search_items' =>  __( 'Select Dental Service Categories', 'photography-custom-post' ),
  	  'all_items' => __( 'All Select Dental Categories', 'photography-custom-post' ),
  	  'parent_item' => __( 'Parent Select Dental Category', 'photography-custom-post' ),
  	  'parent_item_colon' => __( 'Parent Select Dental Category:', 'photography-custom-post' ),
  	  'edit_item' => __( 'Edit Select Dental Category', 'photography-custom-post' ), 
  	  'update_item' => __( 'Update Select Dental Category', 'photography-custom-post' ),
  	  'add_new_item' => __( 'Add New Select Dental Category', 'photography-custom-post' ),
  	  'new_item_name' => __( 'New Select Dental Category Name', 'photography-custom-post' ),
  	); 			
	
	register_taxonomy('selectservicescat', 'select-services', array('hierarchical' => true, 'label' => 'Select Services Categories', 'query_var' => true, 'rewrite' => true));
}
								  
add_action('init', 'post_type_select_services');


function get_hansel_and_gretel_breadcrumbs()
{
	$url = '';
	
    // Set variables for later use
    $here_text        = __( 'You are currently here!' );
    $home_link        = home_url('/');
    $home_text        = __( 'Home' );
    $link_before      = '<span typeof="v:Breadcrumb">';
    $link_after       = '</span>';
    $link_attr        = ' rel="v:url" property="v:title"';
    $link             = $link_before . '<a' . $link_attr . ' href="%1$s">%2$s</a>' . $link_after;
    $delimiter        = ' &raquo; ';              // Delimiter between crumbs
    $before           = '<span class="current">'; // Tag before the current crumb
    $after            = '</span>';                // Tag after the current crumb
    $page_addon       = '';                       // Adds the page number if the query is paged
    $breadcrumb_trail = '';
    $category_links   = '';

    /** 
     * Set our own $wp_the_query variable. Do not use the global variable version due to 
     * reliability
     */
    $wp_the_query   = $GLOBALS['wp_the_query'];
    $queried_object = $wp_the_query->get_queried_object();
	
	 if ( is_singular('select-services') ) 
    {
        /** 
         * Set our own $post variable. Do not use the global variable version due to 
         * reliability. We will set $post_object variable to $GLOBALS['wp_the_query']
         */
        $post_object = sanitize_post( $queried_object );

        // Set variables 
        $title          = apply_filters( 'the_title', $post_object->post_title );
        $parent         = $post_object->post_parent;
        $post_type      = $post_object->post_type;
        $post_id        = $post_object->ID;
        $post_link      = $before . $title . $after;
        $parent_string  = '';
        $post_type_link = '';

        if ( 'select-services' === $post_type ) 
        {
			
            // Get the post categories
            $term_obj_list = wp_get_post_terms( $post_id, 'selectservicescat' );
			
            if ( $term_obj_list ) {
                // Lets grab the first category
                
				if($term_obj_list[0]->slug == 'advanced-care')
				{
					$url = site_url().'/advanced-care/';
				}
				else if($term_obj_list[0]->slug == 'cosmetic')
				{
					$url = site_url().'/dental-services/cosmetic-dentistry-longview';
				} 
				else if($term_obj_list[0]->slug == 'preventative')
				{
					$url = site_url().'/preventative-dentistry/';
				} 
				else if($term_obj_list[0]->slug == 'restorative')
				{
					$url = site_url().'/restorative-dentistry/';
				}
				
				$category_links = '<a href="'.$url.'">' .$term_obj_list[0]->name. '</a>'.$delimiter;
				
            }
        }        

        // Get post parents if $parent !== 0
        if ( 0 !== $parent ) 
        {
            $parent_links = [];
            while ( $parent ) {
                $post_parent = get_post( $parent );

                $parent_links[] = sprintf( $link, esc_url( get_permalink( $post_parent->ID ) ), get_the_title( $post_parent->ID ) );

                $parent = $post_parent->post_parent;
            }

            $parent_links = array_reverse( $parent_links );

            $parent_string = implode( $delimiter, $parent_links );
        }

        // Lets build the breadcrumb trail
        if ( $parent_string ) {
            $breadcrumb_trail = $parent_string . $delimiter . $post_link;
        } else {
            $breadcrumb_trail = $post_link;
        }

        if ( $post_type_link )
            $breadcrumb_trail = $post_type_link . $delimiter . $breadcrumb_trail;

        if ( $category_links )
            $breadcrumb_trail = $category_links . $breadcrumb_trail;
		
    }

    // Handle single post requests which includes single pages, posts and attatchments
    else if ( is_singular() ) 
    {

        $post_object = sanitize_post( $queried_object );

        // Set variables 
        $title          = apply_filters( 'the_title', $post_object->post_title );
        $parent         = $post_object->post_parent;
        $post_type      = $post_object->post_type;
        $post_id        = $post_object->ID;
        $post_link      = $before . $title . $after;
        $parent_string  = '';
        $post_type_link = '';

        if ( 'post' === $post_type ) 
        {
            // Get the post categories
            $categories = get_the_category( $post_id );
            if ( $categories ) {
                // Lets grab the first category
                $category  = $categories[0];

                $category_links = get_category_parents( $category, true, $delimiter );
                $category_links = str_replace( '<a',   $link_before . '<a' . $link_attr, $category_links );
                $category_links = str_replace( '</a>', '</a>' . $link_after,             $category_links );
            }
        }

        if ( !in_array( $post_type, ['post', 'page', 'attachment'] ) )
        {
            $post_type_object = get_post_type_object( $post_type );
            $archive_link     = esc_url( get_post_type_archive_link( $post_type ) );

            $post_type_link   = sprintf( $link, $archive_link, $post_type_object->labels->singular_name );
        }

        // Get post parents if $parent !== 0
        if ( 0 !== $parent ) 
        {
            $parent_links = [];
            while ( $parent ) {
                $post_parent = get_post( $parent );

                $parent_links[] = sprintf( $link, esc_url( get_permalink( $post_parent->ID ) ), get_the_title( $post_parent->ID ) );

                $parent = $post_parent->post_parent;
            }

            $parent_links = array_reverse( $parent_links );

            $parent_string = implode( $delimiter, $parent_links );
        }

        // Lets build the breadcrumb trail
        if ( $parent_string ) {
            $breadcrumb_trail = $parent_string . $delimiter . $post_link;
        } else {
            $breadcrumb_trail = $post_link;
        }

        if ( $post_type_link )
            $breadcrumb_trail = $post_type_link . $delimiter . $breadcrumb_trail;

        if ( $category_links )
            $breadcrumb_trail = $category_links . $breadcrumb_trail;
    } 

    // Handle archives which includes category-, tag-, taxonomy-, date-, custom post type archives and author archives
    if( is_archive() )
    {
        if (    is_category()
             || is_tag()
             || is_tax()
        ) {
            // Set the variables for this section
            $term_object        = get_term( $queried_object );
            $taxonomy           = $term_object->taxonomy;
            $term_id            = $term_object->term_id;
            $term_name          = $term_object->name;
            $term_parent        = $term_object->parent;
            $taxonomy_object    = get_taxonomy( $taxonomy );
            $current_term_link  = $before . $taxonomy_object->labels->singular_name . ': ' . $term_name . $after;
            $parent_term_string = '';

            if ( 0 !== $term_parent )
            {
                // Get all the current term ancestors
                $parent_term_links = [];
                while ( $term_parent ) {
                    $term = get_term( $term_parent, $taxonomy );

                    $parent_term_links[] = sprintf( $link, esc_url( get_term_link( $term ) ), $term->name );

                    $term_parent = $term->parent;
                }

                $parent_term_links  = array_reverse( $parent_term_links );
                $parent_term_string = implode( $delimiter, $parent_term_links );
            }

            if ( $parent_term_string ) {
                $breadcrumb_trail = $parent_term_string . $delimiter . $current_term_link;
            } else {
                $breadcrumb_trail = $current_term_link;
            }

        } elseif ( is_author() ) {

            $breadcrumb_trail = __( 'Author archive for ') .  $before . $queried_object->data->display_name . $after;

        } elseif ( is_date() ) {
            // Set default variables
            $year     = $wp_the_query->query_vars['year'];
            $monthnum = $wp_the_query->query_vars['monthnum'];
            $day      = $wp_the_query->query_vars['day'];

            // Get the month name if $monthnum has a value
            if ( $monthnum ) {
                $date_time  = DateTime::createFromFormat( '!m', $monthnum );
                $month_name = $date_time->format( 'F' );
            }

            if ( is_year() ) {

                $breadcrumb_trail = $before . $year . $after;

            } elseif( is_month() ) {

                $year_link        = sprintf( $link, esc_url( get_year_link( $year ) ), $year );

                $breadcrumb_trail = $year_link . $delimiter . $before . $month_name . $after;

            } elseif( is_day() ) {

                $year_link        = sprintf( $link, esc_url( get_year_link( $year ) ),             $year       );
                $month_link       = sprintf( $link, esc_url( get_month_link( $year, $monthnum ) ), $month_name );

                $breadcrumb_trail = $year_link . $delimiter . $month_link . $delimiter . $before . $day . $after;
            }

        } elseif ( is_post_type_archive() ) {

            $post_type        = $wp_the_query->query_vars['post_type'];
            $post_type_object = get_post_type_object( $post_type );

            $breadcrumb_trail = $before . $post_type_object->labels->singular_name . $after;

        }
    }   

    // Handle the search page
    if ( is_search() ) {
        $breadcrumb_trail = __( 'Search query for: ' ) . $before . get_search_query() . $after;
    }

    // Handle 404's
    if ( is_404() ) {
        $breadcrumb_trail = $before . __( 'Error 404' ) . $after;
    }

    // Handle paged pages
    if ( is_paged() ) {
        $current_page = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : get_query_var( 'page' );
        $page_addon   = $before . sprintf( __( ' ( Page %s )' ), number_format_i18n( $current_page ) ) . $after;
    }

    $breadcrumb_output_link  = '';
    $breadcrumb_output_link .= '<div class="breadcrumb" role="navigation">';
    if (    is_home()
         || is_front_page()
    ) {
        // Do not show breadcrumbs on page one of home and frontpage
        if ( is_paged() ) {
            //$breadcrumb_output_link .= $here_text . $delimiter;
            $breadcrumb_output_link .= '<a href="' . $home_link . '">' . $home_text . '</a>';
            $breadcrumb_output_link .= $page_addon;
        }
    } else {
        //$breadcrumb_output_link .= $here_text . $delimiter;
        $breadcrumb_output_link .= '<a href="' . $home_link . '" rel="v:url" property="v:title">' . $home_text . '</a>';
        $breadcrumb_output_link .= $delimiter;
        $breadcrumb_output_link .= $breadcrumb_trail;
        $breadcrumb_output_link .= $page_addon;
    }
    $breadcrumb_output_link .= '</div><!-- .breadcrumbs -->';

    return $breadcrumb_output_link;
}


add_shortcode( 'custom_breadcrumb', 'get_hansel_and_gretel_breadcrumbs' );


function category_posts_function() {
	
	$html = '';
	
	$html .= '<ul class="ulRow cosmetic_row">';
	
		$custom_query = new WP_Query( 
			array(
				'posts_per_page' => -1,
				'post_type' => 'select-services',
				'showposts' => '-1',
				'post_status' => 'publish',									
				'orderby' => 'title',	
				'order' => 'ASC',		
				'tax_query' => array(
					array(
						'taxonomy' => 'selectservicescat',
						'field' => 'slug',
						'terms' => 'cosmetic',
					)
				)
			)
		);
		
		
		if ( $custom_query->have_posts() ) : while ( $custom_query->have_posts() ) : $custom_query->the_post();
		
		global $post;
		
		$html .= '<li> <a href="'.get_the_permalink($post->ID).'"> '.get_the_title($post->ID).' </a> </li>'; 
		
		endwhile; endif;  wp_reset_query();
	
	$html .= '</ul>';
	
	return $html;
}

add_shortcode( 'category_posts', 'category_posts_function' );


function specific_category_posts_scroll_function($attr) {

	$term_slug = $attr['slug'];
	
	$html = '';
	
	$html .= '<ul class="ulRow scroll_row">';
	
		$custom_query = new WP_Query( 
			array(
				'posts_per_page' => -1,
				'post_type' => 'select-services',
				'showposts' => '-1',
				'post_status' => 'publish',									
				'orderby' => 'title',	
				'order' => 'ASC',		
				'tax_query' => array(
					array(
						'taxonomy' => 'selectservicescat',
						'field' => 'slug',
						'terms' => $term_slug,
					)
				)
			)
		);
		
		
		if ( $custom_query->have_posts() ) : while ( $custom_query->have_posts() ) : $custom_query->the_post();
		
		global $post;
		
		$html .= '<li><a class="" href="#'.$post->post_name.'"> '.get_the_title($post->ID).' </a></li>';		
		
		endwhile; endif;  wp_reset_query();
	
	$html .= '</ul>';
	
	return $html;
}

add_shortcode( 'scroll_services', 'specific_category_posts_scroll_function' );


function specific_category_posts_function($attr) {

	$term_slug = $attr['slug'];
	
	$html = '';
	
	$html .= '<div class="specific_category_posts">';
	
		$custom_query = new WP_Query( 
			array(
				'posts_per_page' => -1,
				'post_type' => 'select-services',
				'showposts' => '-1',
				'post_status' => 'publish',									
				'orderby' => 'title',	
				'order' => 'ASC',		
				'tax_query' => array(
					array(
						'taxonomy' => 'selectservicescat',
						'field' => 'slug',
						'terms' => $term_slug,
					)
				)
			)
		);
		
		
		if ( $custom_query->have_posts() ) : while ( $custom_query->have_posts() ) : $custom_query->the_post();
		
		global $post;
		
		$html .= '<div class="inner_spe_po" id="'.$post->post_name.'"> 
					<h2> '.get_the_title($post->ID).' </h2>
					<p> '.get_the_excerpt($post->ID).' </p>		
					<a class="et_pb_button" href="'.get_the_permalink($post->ID).'"> Learn more about '.get_the_title($post->ID).' </a> 
				 </div>';		
		endwhile; endif;  wp_reset_query();
	
	$html .= '</div>';
	
	return $html;
}

add_shortcode( 'specific_category_posts', 'specific_category_posts_function' );



add_shortcode( 'fullscreen_menu', 'fullscreen_menu_function' );
function fullscreen_menu_function($attr) {

	ob_start();
		
	if(isset($attr['menu']) and $attr['menu'] != "")
	{
		$menu_name = $attr['menu'];
		?>
		<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/menu/menu_style.min.css?v=<?php echo time(); ?>">
		<script type="text/javascript" src="<?php echo get_stylesheet_directory_uri(); ?>/menu/menu_script.min.js?v=<?php echo time(); ?>" defer=""></script>
		<div class="row top grid">
			<nav class="tresio-nav tresio-menu-holder variant-popup tresio-nav--loaded type-hamburger" data-type-desktop="hamburger" data-type-tablet="hamburger" data-type-mobile="hamburger" data-variant-desktop="popup" data-variant-tablet="default" data-variant-mobile="default" data-dropdown-label="»" data-hamburger-color="#000" data-hamburger-color-expanded="#000" data-menu-offset="0" data-menu-offset-mobile="0" data-type="hamburger" data-variant="popup">
				<a class="tresio-nav__hamburger" style="display: none;" href="#" aria-label="Open/Close Menu" aria-expanded="false" aria-haspopup="true" role="button">
					<span aria-hidden="true"></span>
				</a>
				<?php
				wp_nav_menu( 
					array( 
						'menu' => $menu_name,
						'container' => '',
						'menu_class' => 'tresio-nav__main tresio-nav__list level-1'
					) 
				);
				?>
			</nav>
		</div>
		<?php
	}
	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}

add_filter('wp_nav_menu_items', 'do_shortcode');
function add_description_to_menu($item_output, $item, $depth, $args) {

   if (strlen($item->description) > 0 ) {
      // append description after link
      // $item_output .= sprintf('<span class="description">%s</span>', esc_html($item->description));
    
      // or.. insert description as last item inside the link ($item_output ends with "</a>{$args->after}")
      $item_output = substr($item_output, 0, -strlen("</a>{$args->after}")) . sprintf('<span class="description">%s</span >', esc_html($item->description)) . "</a>{$args->after}";
   }   
   return $item_output;
}



add_filter('walker_nav_menu_start_el', 'add_description_to_menu', 10, 4);


function services_menu_function() {

	//$term_slug = $attr['cat'];
	
	$html = '';
	
	$html .= '<ul class="specific_category_menu_posts">';
						$catsArray = array(11, 8, 9, 10);
						$args = array(
						   'taxonomy' => 'selectservicescat',
						   'include' => $catsArray,
						   'orderby' => 'include',
						   'order'   => 'ASC',
						   'hide_empty' => true,
						   'exclude' => 214,
					    );
						
						
			
						$cats = get_terms($args);
					
						// loop through the categries
						foreach ($cats as $cat) {
							
							// setup the cateogory ID
							$cat_slug= $cat->slug;
							
							if($cat_slug == 'advanced-care')
							{
								$url = site_url().'/advanced-care';
							}
							else if($cat_slug == 'cosmetic')
							{
								$url = site_url().'/dental-services/cosmetic-dentistry-longview';
							} 
							else if($cat_slug == 'preventative')
							{
								$url = site_url().'/preventative-dentistry';
							} 
							else if($cat_slug == 'restorative')
							{
								$url = site_url().'/restorative-dentistry';
							}
							
							$custom_query = new WP_Query( 
								array(
									'posts_per_page' => -1,
									'post_type' => 'select-services',
									'post_status' => 'publish',	
									'meta_key'       => 'orderNo',
									'orderby'        => 'meta_value_num',
									'order'          => 'ASC',		
									'tax_query' => array(
										array(
											'taxonomy' => 'selectservicescat',
											'field' => 'term_id',
											'terms' => $cat->term_id,
										)
									)
								)
							);
							
						
						$html .= "<div class='menu_columns'>";
							// create a custom wordpress query
						
								if ( $custom_query->have_posts() ) : 
								$html .= "<li class='category_name menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children'><a class='cat_name' href=".$url.">".$cat->name."</a>";
								$html .= "<ul class='mega-sub-menu sub-menu'>";
								while ( $custom_query->have_posts() ) : $custom_query->the_post();
									
									global $post;
								
									$html .= '<li class="li_menu mega-menu-item mega-menu-item-type-widget tresio-nav__list-item level-3"> <a class="tresio-nav__link level-3" href="'.get_the_permalink($post->ID).'">  '.get_the_title($post->ID).' </a> </li>';		
								
								endwhile;  
								wp_reset_query();
									
									if($cat_slug == 'preventative') {
										$html .= '<li class="li_menu mega-menu-item mega-menu-item-type-widget tresio-nav__list-item level-3"> <a class="tresio-nav__link level-3" href="'.get_the_permalink(27090).'">  '.get_the_title(27090).' </a> </li>';
										$html .= '<li class="li_menu mega-menu-item mega-menu-item-type-widget tresio-nav__list-item level-3"> <a class="tresio-nav__link level-3" href="'.get_the_permalink(26794).'">  '.get_the_title(26794).' </a> </li>';																		
									}
							
							
								$html .= '</ul></li>';
						
						endif;  
	
	
							
						$html .= '</div>';
						}
						
	
	$html .= '</ul>';
	
	return $html;
}

add_shortcode( 'services_menu', 'services_menu_function' );



add_action('wp_head', 'add_mobile_script');
function add_mobile_script(){
?>
<script type="text/javascript">
	
jQuery( document ).ready(function() {	
		
		jQuery('.sticky-contact').css('display','none');    
		jQuery('.sticky-contact').fadeOut();
		var positionn = jQuery(window).scrollTop();
		
		
		jQuery('.effects .et_pb_image').hover(
		  function() {
			jQuery( this ).addClass( "hover" );
		  }, function() {
			jQuery( this ).removeClass( "hover" );
		  }
		);
	
		jQuery(window).scroll(function() {
			 var scroll = jQuery(window).scrollTop();
			 if(scroll > 100) {
				 	jQuery('.sticky-contact').css('display','block');  
				 jQuery('.sticky-contact').fadeIn();	
			  } else {
				jQuery('.sticky-contact').fadeOut();
			 }
		});
		
		var position = jQuery(window).scrollTop();	
		jQuery(window).scroll(function() {
			 var scroll = jQuery(window).scrollTop();
			 jQuery('.home .logo_header').css('display','none'); 
			 if(scroll > 100) {
				 jQuery('.header_tra').addClass('mbo_header');  
				 jQuery('.home .logo_header').css('display','block'); 
				 jQuery('.scrollhs').css('display','block'); 	
				 jQuery('.home .logo_header').fadeIn();	
				 jQuery('.header_tra').css('position','fixed');
				 jQuery('.header_tra').css('top','0');		
			  } else {
				jQuery('.home .logo_header').fadeOut();
				jQuery('.header_tra').removeClass('mbo_header');  
				 jQuery('.header_tra').css('position','relative'); 
				 jQuery('.scrollhs').css('display','none');  
			 }
		});
});	
	
	
(function($) {
      
    function setup_collapsible_submenus() {
        var $menu = $('#menu-header'),
            top_level_link = '#menu-header .menu-item-has-children > a';
             
        $menu.find('a').each(function() {
              
            if ( ! $(this).siblings('.sub-menu').length ) {
                $(this).on('click', function(event) {
                    $(this).parents('.mobile_nav').trigger('click');
                });
            } else {
                $(this).on('click', function(event) {
                    event.preventDefault();
                    $(this).parent().toggleClass('visible');
                });
            }
        });
    }
      
    $(window).load(function() {
        setTimeout(function() {
            setup_collapsible_submenus();
        }, 700);
    });
 
})(jQuery);
</script>
<?php }



add_filter( 'style_loader_src', 'add_static_version_to_assets', 9999 );
add_filter( 'script_loader_src', 'add_static_version_to_assets', 9999 );
function add_static_version_to_assets( $src ) {
    // Remove any existing ?ver=
    $src = remove_query_arg( 'ver', $src );

    // Set your static version number
    $static_version = '8.8.5'; // ← change as needed

    // Add the static version
    return add_query_arg( 'ver', $static_version, $src );
}

?>